-- Ahdoc msg for committee

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'GEN_INVOICE_STUDENT_ADHOC', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GEN_INVOICE_STUDENT_ADHOC');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'GEN_INVOICE_STUDENT_ADHOC');

INSERT INTO `adhoc_msg_recipient_type` (`msgRecipientTypeId`, `distrListProviderId`) VALUES (@msgRecipientId+1, @dtproviderId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GEN_INVOICE_STUDENT_ADHOC');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT 
    b.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    b.totalAmount AS TOTAL_AMOUNT,
    b.billNo AS BILL_NO,
    b.dueDate AS DUE_DATE
FROM
    bill_header b
        JOIN
    students st ON st.userId = b.studentId
        JOIN
    persons p ON p.id = st.personId
WHERE
    b.id IN (namedParams) 
UNION SELECT 
    b.id AS ID,
    ap.emailId AS EMAIL_ID,
    ap.mobileNumber AS MOBILE_NO,
    ap.mobileCountryCode AS MOBILE_CODE,
    ap.printName AS PRINT_NAME,
    ap.firstName AS FIRST_NAME,
    ap.lastName AS LAST_NAME,
    b.totalAmount AS TOTAL_AMOUNT,
    b.billNo AS BILL_NO,
    b.dueDate AS DUE_DATE
FROM
    bill_header b
        JOIN
    application a ON a.id = b.applicantId
        JOIN
    applicant_person ap ON ap.id = a.applicantPersonId
WHERE
    b.id IN (namedParams) 
UNION SELECT 
    b.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    b.totalAmount AS TOTAL_AMOUNT,
    b.billNo AS BILL_NO,
    b.dueDate AS DUE_DATE
FROM
    bill_header b
        JOIN
    staffs stf ON stf.userId = b.userId
        JOIN
    persons p ON p.id = stf.personId
WHERE
    b.id IN (namedParams) 
UNION SELECT 
    b.id AS ID,
    ft.emailId AS EMAIL_ID,
    ft.cellNo AS MOBILE_NO,
    '+91' AS MOBILE_CODE,
    ft.printName AS PRINT_NAME,
    ft.firstName AS FIRST_NAME,
    ft.lastName AS LAST_NAME,
    b.totalAmount AS TOTAL_AMOUNT,
    b.billNo AS BILL_NO,
    b.dueDate AS DUE_DATE
FROM
    bill_header b
        JOIN
    fee_third_parties ft ON ft.id = b.thirdPartyId
WHERE
    b.id IN (namedParams)
UNION SELECT 
    b.id AS ID,
    ad.primaryeEmailId AS EMAIL_ID,
    ad.cellNo AS MOBILE_NO,
    ad.cellCountryCode AS MOBILE_CODE,
    sc.contactName AS PRINT_NAME,
    sc.contactName AS FIRST_NAME,
    ' ' AS LAST_NAME,
    b.totalAmount AS TOTAL_AMOUNT,
    b.billNo AS BILL_NO,
    b.dueDate AS DUE_DATE
FROM
    bill_header b
        JOIN
    sponsors spo ON spo.id = b.sponsorId
    join 
    sponsor_contacts sc on sc.sponsorId = spo.id
    join address ad on ad.id = sc.addressId
WHERE
    b.id IN (namedParams)
    and sc.id =  (select id from sponsors s where s.id =
   (select min(sc.id) from sponsor_contacts sc where sc.sponsorId = spo.id ))",'{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "totalAmount",
            "resultKey": "TOTAL_AMOUNT",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "billNo",
            "resultKey": "BILL_NO",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "dueDate",
            "resultKey": "DUE_DATE",
            "displayCode": "",
            "displayOrder": 6
        }
    ]}');

-- set predefine msg template for committeee
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='GEN_INVOICE_STUDENT_ADHOC');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`,`approvalRequired`,`approverId`,`whetherStaticMsg`,`status`,`availableForAdhocMsg`,`academyLocationId`,`authorName`,`authorId`) 
VALUES (@msgTemplateConfigId+1,'Generated Invoice Reminder',64,NULL,@msgrecipienttypeId,4,NULL,NULL,'Generated Invoice Reminder',NULL,0,NULL,0,'APPROVED',1,1,'System Admin',1);



INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Invoice','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Invoice is generated for you. Please find the attached Invoice document for the
details.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');

/*INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Bill Invoice','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Take home assignment has been given to you for $recipientData["COURSE_CODE"]/$recipientData["COURSE_NAME_TO_BE_PRINTED"]. The submission
deadline is $recipientData["CURRENT_DATE_TIME"]. Please log in to Student Portal for more details.</span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');*/








